// View.cpp starts

#include <stdio.h>
#include "View.h"
#include "EnvironmentConstants.h"
#include "Debug.h"

bool ViewsEqual(float *view1, float *view2)
{
	for (int i=0; i < LANDMARK_VIEW_WIDTH; i++) {
		if (view1[i] != view2[i]) {
			return false;
		}
	}
	
	return true;
}

// Copy view2 to view1
void CopyView(float *view1, float *view2)
{
	for (int i=0; i < LANDMARK_VIEW_WIDTH; i++) {
		view1[i] = view2[i];
	}
}

void DebugView(float *view)
{
	char buffer[256];
	
	sprintf(buffer, "%.1f,%.1f,%.1f,%.1f (%.1f) %.1f,%.1f,%.1f,%.1f",
		view[0],view[1],view[2],view[3],view[4],view[5],view[6],view[7],view[8]);
	Debug('t', "DebugView: View: ", buffer);
}

double VectorDistance(float* v1, float* v2)
{
  double sum = 0.0;
    
  for (int i=0; i < LANDMARK_VIEW_WIDTH; i++) {
    sum += pow(v1[i] - v2[i], 2);
  }
  
  return pow(sum, 0.5);
}

int NumberSharedElements(float* v1, float* v2)
{
	bool v2Matched[LANDMARK_VIEW_WIDTH];
	int shared = 0;
	int i;
	
	for (i=0; i < LANDMARK_VIEW_WIDTH; i++)
		v2Matched[i] = false;
		
	for (i=0; i < LANDMARK_VIEW_WIDTH; i++) {
		// Determine if element v1[i] is in view v2
		for (int j=0; j < LANDMARK_VIEW_WIDTH; j++) {
			if ((! v2Matched[j]) && (v2[j] == v1[i])) {
				v2Matched[j] = true;
				shared++;
				break;
			}
		}
	}
	
	return shared;
}

// View.cpp ends
